# Biblical Wisdom in its Ancient Near Eastern Context

## 圣经智慧文学

智慧文学分为如下两种:

1. 实践智慧（practical wisdom）:  它包括谚语和建议，就像在箴言书（the Book of Proverbs）里的那样。这些涉及日常生活适当的社会行为，理想和不良的个人特征，正确使用金钱和财产等。
2. 沉思智慧（contemplative wisdom）：它涉及诸如邪恶和神论的问题或生活的主题问题等哲学问题。这种智慧主要代表是圣经的 Job 书和 Qohelet 书。

学者们相信这三本圣经书籍：箴言，Job 书和 Qohelet书，反映了一种特定的智慧文学传统。在希伯来语中，这种传统被称为 חכמה（hokmdh），智慧。传递它的人被称为חכמים（hakamim），明智的人。

智慧文学有许多特殊的特征，使其与其他圣经类型区别开来。其中之一是它倾向于解决个人而不是集体。智慧的价值观与每个人都有关系，而不仅仅是以色列人。我们刚才提出的谚语是普遍的，而Job和Qohelet所处理的哲学问题是泛人类的。这种特征使圣经智慧文学特别容易受到外在影响。实际上，圣经明确指出智慧文学与其他文化有着密切的联系。箴言引用了非以色列圣人的话（参见箴言30:1）。约伯和他的朋友都是外国人。圣经中最聪明人的智慧 - 所罗门王 - 也被置于国际背景之下，他比任何人都聪明包括东方人和埃及人。智慧文学的国际化风格为这一类型的比较研究创造了肥沃的土壤。



## 圣经和埃及的实践智慧

在古代近东，特别是在美索不达米亚和埃及，发现了许多属于智慧文学的文本。我们在苏美尔人，阿卡德人，埃及人和亚拉姆人中都知道类似于圣经箴言书的谚语集。也发现了与Job和Qohelet类似的沉思智慧作品。其中一些与圣经对应物具有特定的相似之处。

有趣的是，在实践智慧领域，最重要的相似之处并非来自美索不达米亚，而是来自埃及。埃及与圣经文学之间最重要的接触点出现在==实践智慧==领域。

埃及人发展了一种持久的智慧传统。在整个埃及历史中，收集了智慧指示和谚语。这些收藏品通常是国王给他儿子的好建议。它们在许多方面类似于圣经谚语。

1. 它们处理类似的话题，比如如何在王室中表现;适当的餐桌礼仪;如何与一个敌人保持距离，等等。
2. 这两个传统具有相似的框架和价值观。两者都试图教育年轻一代如何在生活中取得成功。两者都建议诚信和体面，但在功利主义的基础上赞同这一建议。
3. 两种传统之间的语言联系证明了它们之间的密切联系。在圣经中的箴言书中，思想和意识的位置有时被称为 “chambers of the belly” (腹室)。然而，这种表达对于圣经的用语来说是陌生的。圣经通常将意识的位置分配给心脏而不是腹部。然而在埃及智慧被认为是从肚子里产生的。<u>箴言中这种表达的出现可能反映了埃及智慧的影响</u>。



## 智者之言

在圣经箴言书中的 22:17–24:22 被成为**智者之言**（Words of the Wise）。

> Have I not written for you šālı̂šı̂m of admonition and knowledge? 
> (Prov 22:20) 

希伯来语这个词 salisim 在这里显然是不合适的：它意味着“军官”，或者在其他情况下，是一种测量或乐器。这些意义都与智慧说法无关。

等等奇怪的例子很多，直到评论家们发现了埃及的智慧书 ==Proverbs of Amenemope==。

这是埃及圣人 Amenemope 给他年幼的儿子发表的一系列谚语，以教他“生命之路”。它包含三十章，每一章专门讨论一个特定的话题。书中反映的主题和价值观是埃及智慧的典型。根据Amenemope 的说法，理想的人是自我控制和敬畏神。

Amenemope 谚语于1923年首次出版。一年后，埃及学家阿道夫·埃尔曼（==Adolf Erman==）注意到本谚语集与圣经中的“智慧之言”之间有惊人的相似之处。事实证明，第一部分中的每一节经文都是如此。

以下是一些例子：

1. 反对从被压迫者身上偷窃的警告。
2. 不要侵犯你祖先所造的边界
3. 以前在吃饭之前不要在官员面前吃食物
4. 不要把你的心全力投入到财富上
5. 不要与一个吝啬的人一起用餐

这些相似之处的集中和突出表明了文学的直接依赖性。

salisim 实际上应该读作 slosim（希伯来语的30） 对应的埃及Amenemope智慧书是合理的。这里说埃及智慧书有30章。圣经文本中没有明确标明这种划分。然而，当试图统计指示时，许多学者得出结论，该集合确实包含30条指令，可能是在Amenemope指令的启发下。希伯来语集合可能包含三十个语句：埃及语集合包括三十章。这个特定的连接涉及单元的数量而不是它们的长度或内容。

另一个例子，Amenemope在这里谈论一位国王派遣的**特使**（envoy），或者是一位有望报道他的使命的人。因此，这节经文指出，圣人的目标之一是训练王室官员。年轻人应该掌握的技能之一是如何成为忠诚和高效的使者。忠诚信使的主题是埃及和圣经智慧的核心。古代近东官僚体系严重依赖忠诚的人来传递口头和书面信息。箴言中的几句谚语说明了好使和坏使者的素质。“给那些送你的人回答”。

最后一个例子：

> Have you seen a man diligent in his work? He will stand before kings. He will not stand before obscure men (Prov 22:29). 

这在圣经中是不通顺的，但是对比埃及智慧书，箴言中提到的人很可能是受过良好训练的**抄写员**。由于他的勤奋，他将“站在国王面前” - 也就是说，在宫殿中获得一席之地。



## 智者之言和埃及智慧书的关系

一些特征表明，**希伯来文字抄写员借鉴了埃及的材料**，而不是相反。这是因为：

1. 一些希伯来文本，在发现埃及来源之前在许多地方都是模糊不清的。
2. 圣经中的几个主题和对象在本质上是埃及化的。

当然，随着对材料的深入研究，我们也揭示了一些差异。比如在 箴言书 23:4–5 中希伯来作者把其中的鹅改成了老鹰。其原因似乎与他的地理和动物环境有关：虽然鹅是尼罗河和埃及景观的水鸟特征，但鹰在以色列土地上很常见，因此对以色列读者更为熟悉。

在另一个关于不要跨国边境的例子中，这两个箴言都提供了类似的理由：侵入者将受到神圣力量的惩罚。希伯来诗句说：“因为他们的守护者是强者。他会代表他们与你抗争。” 根据圣经的精神，一个人的遗产属于一个人的一生。

在希伯来语集合中出现了其他分歧。例如，希伯来编辑用上帝代替埃及神灵的名字。这位匿名编辑似乎试图做一些小改动，以使文本适合以色列文化。然而绝大多数材料都没有受到影响。

圣经编辑并不批评他借用的文化的思想和内容。他并没有试图用沉重的手来纠正或谴责他们。相反，<u>他似乎将借鉴其他智慧传统视为一种自然而可接受的惯例。</u>在他看来，唯一需要的改变是对材料适合以色列环境的小改编。这种态度符合以色列智慧文学的普遍性和世界性。



whzecomjm
20190623